% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state.R
\name{toHash}
\alias{fromHash}
\alias{toHash}
\title{Methods for dealing with state and hashes}
\usage{
toHash(x)

fromHash(x)
}
\arguments{
\item{x}{state or hash object}
}
\description{
Methods for dealing with state and hashes
}
\note{
Used in \code{\link{makeStateHash}}.
}
\examples{
state <- stateSpec(
  name = "my_display",
  sort = list(state = "desc", county = "asc"),
  filter = list(
    county = list(regex = "Ben"),
    state = list(select = c("OR", "WA")),
    meanList = list(from = 50, to = 150)
  ),
  layout = list(nrow = 2, ncol = 4),
  labels = c("county", "state")
)

state <- validateState(state, checkDisplay = FALSE)

makeStateHash(state)
}

