% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cog.R
\name{cog_href}
\alias{cog_href}
\title{Href Cognostic}
\usage{
cog_href(x, desc = "link", group = "common", default_label = FALSE,
  default_active = FALSE, filterable = FALSE, sortable = FALSE,
  log = FALSE)
}
\arguments{
\item{x}{URL to link to}

\item{desc, group, default_label, default_active, filterable, sortable, log}{arguments passed to \code{\link{cog}}}
}
\description{
Create href to be used as cognostics in a trelliscope display
}
\examples{
\donttest{
library(dplyr)
library(rbokeh)
iris \%>\%
  group_by(Species) \%>\%
  summarise(
    wiki_link = cog_href(paste0("https://en.wikipedia.org/wiki/Iris_",
      tolower(Species))[1], default_label = TRUE,
      desc = "link to species on wikipedia"),
    panel = panel(figure(xlab = "Sepal Length", ylab = "Sepal Width") \%>\%
      ly_points(Sepal.Length, Sepal.Width))) \%>\%
  trelliscope(name = "iris_species", ncol = 3)
}
}
\seealso{
\code{\link{cog}}
}
