% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EffTox.R
\name{efftox_superiority}
\alias{efftox_superiority}
\title{Get dose-superiority matrix in EffTox}
\usage{
efftox_superiority(fit)
}
\arguments{
\item{fit}{An instance of \code{rstan::stanmodel}, derived by sampling an
EffTox model. Use \code{stan::sampling(stanmodels$EffTox, data = dat)}.}
}
\value{
n by n matrix, where n is number of doses under investigation.
The item in row i, col j is the posterior probability that the utility of
dose j exceeds that of dose i.
}
\description{
Get a dose-superiority matrix from an EffTox dose analysis.
EffTox seeks to choose the dose with the highest utility, thus superiority
is inferred by posterior utility. The item in row i, col j is the posterior
probability that the utility of dose j exceeds that of dose i.
}
\examples{
dat <- efftox_parameters_demo()
dat$num_patients <- 3
dat$eff <- c(0, 1, 1)
dat$tox <- c(0, 0, 1)
dat$doses <- c(1, 2, 3)
fit <- rstan::sampling(stanmodels$EffTox, data = dat)
sup_mat <- efftox_superiority(fit)
}
