% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tricolore.R
\name{Tricolore}
\alias{Tricolore}
\title{Ternary Balance Color Scale}
\usage{
Tricolore(df, p1, p2, p3, breaks = 100, hue = 0, chroma = 0.8,
  lightness = 0.7, contrast = 0.4, center = rep(1/3, 3), spread = 1,
  legend = TRUE, show_data = TRUE, show_center = TRUE,
  input_validation = TRUE)
}
\arguments{
\item{df}{Data frame of compositional data.}

\item{p1}{Column name for variable in df giving first proportion
of ternary composition (string).}

\item{p2}{Column name for variable in df giving second proportion
of ternary composition (string).}

\item{p3}{Column name for variable in df giving third proportion
of ternary composition (string).}

\item{breaks}{Number of per-axis breaks in the discrete color scale.
An integer >0. Values above 99 imply no discretization.}

\item{hue}{Primary hue of the first ternary element (0 to 1).}

\item{chroma}{Maximum possible chroma of mixed colors (0 to 1).}

\item{lightness}{Lightness of mixed colors (0 to 1).}

\item{contrast}{Lightness contrast of the color scale (0 to 1).}

\item{center}{Ternary coordinates of the color scale center.
(default = 1/3,1/3,1/3). NA puts center over the compositional
mean of the data.}

\item{spread}{The spread of the color scale. Choose values > 1 to focus the
color scale on the center.}

\item{legend}{Should a legend be returned along with the colors? (default=TRUE)}

\item{show_data}{Should the data be shown on the legend? (default=TRUE)}

\item{show_center}{Should the center be shown on the legend? (default=TRUE)}

\item{input_validation}{Should the function arguments be validated? (default=TRUE)}
}
\value{
\itemize{
\item legend=FALSE: A vector of rgbs hex-codes representing the ternary balance
scheme colors.
\item legend=TRUE: A list with elements "hexsrgb" and "legend".
}
}
\description{
Color-code three-part compositions with a ternary balance color scale and
return a color key.
}
\examples{
P <- as.data.frame(prop.table(matrix(runif(3^6), ncol = 3), 1))
Tricolore(P, 'V1', 'V2', 'V3')

}
