% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_gbounds.R
\name{gbounds}
\alias{gbounds}
\title{Critical boundary in group sequential trials}
\usage{
gbounds(t, iuse = 1, alpha = 0.05, phi = rep(1, length(alpha)))
}
\arguments{
\item{t}{a vector of information times}

\item{iuse}{a number of the type of the error spending function, from -2, -1, 1, 2, 3, 4}

\item{alpha}{a number of type I error rate}

\item{phi}{a parameter for the power family or the HSD gamma family}
}
\value{
a list of two vectors: \code{bd} critical boundaries, \code{er} error spent until each stage
}
\description{
This function computes the critical boundaries and the error spent until each stage in group sequential trials
}
\details{
If the original Pocock is implemented, we specify \code{iuse=-2}. If the original OBrien-Flemming is implemented, we specify \code{iuse=-1}.
}
\examples{
t<-c(0.5,0.8,1)
iuse <- 4
gbounds(t=t, iuse=iuse)
gbounds(t=(1:5)/5, iuse=4, alpha=0.01, phi=-4)
gbounds(t=(1:5)/5, iuse=-2, alpha=0.01)
}
\author{
Jiangtao Gou
}
