% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emp.vus.R
\name{emp.vus}
\alias{emp.vus}
\title{Empirical VUS calculation}
\usage{
emp.vus(x, y, z, dat = NULL, old.version = TRUE)
}
\arguments{
\item{x, y, z}{Numeric vectors contaning the measurements from the healthy,
intermediate and diseased class.}

\item{dat}{A data frame of the following structure: The first column
represents a factor with three levels, containing the true class membership
of each measurement. The levels are ordered according to the convention of
higher values for more severe disease status. The second column contains
all measurements obtained from Classifier.}

\item{old.version}{A logical to switch computation method to the old version,
which is up to 50\% faster in computation (at N=50).}
}
\value{
It returns the numeric \code{VUS} of the data.
}
\description{
This function computes the empirical Volume Under the Surface (VUS)
of three-class ROC data.
}
\details{
This function computes the empirical VUS of three-class ROC data
  using the \code{expand.grid} function. It has been shown to be faster than
  computation using the \code{merge} function (\code{VUS.merge()}) or direct
  geometrical imlementation. The measurements can be input as seperate vectors
  \code{x, y, z} or as a data frame \code{dat}.
}
\examples{
data(krebs)
x1 <- with(krebs, cancer[trueClass=="healthy", 4])
y1 <- with(krebs, cancer[trueClass=="intermediate", 4])
z1 <- with(krebs, cancer[trueClass=="diseased", 4])

emp.vus(x1, y1, z1)
# Alternatively:
emp.vus(dat = krebs[,c(1,4)])
}
\references{
Scurfield, B. K. (1996). Multiple-event forced-choice tasks in
  the theory of signal detectability. \emph{Journal of Mathematical
  Psychology} \bold{40.3}, 253–269.

Nakas CT and Yiannoutsos CT (2004) Ordered multiple-class roc
  analysis with continuous measurements. \emph{Statistics in Medicine} \bold{23}(22):
  3437–3449.
}
