% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rocsurf.trin.R
\name{rocsurf.trin}
\alias{rocsurf.trin}
\title{Trinormal ROC surface plot}
\usage{
rocsurf.trin(x, y, z, p = 300, plot = TRUE, saveVUS = FALSE)
}
\arguments{
\item{x, y, z}{Vectors containing the data of the three classes "healthy",
"intermediate" and "diseased".}

\item{p}{An integer for the precision of the surface. \code{p} gives the
number of gridpoints per axis.}

\item{plot}{logical. If TRUE (default), the VUS is plotted using \code{surface3d} from the package \code{rgl}.}

\item{saveVUS}{A logical whether to save a PNG of the VUS in your current
working directory (default is \code{FALSE}).}
}
\value{
A list with the following components:
  \item{t1, t2}{The vectors \eqn{t_-=F_-^{(c_-)}} and \eqn{t_+=F_+^{(c_+)}}}
  \item{zVUS}{The matix containing the surface values.}
  \item{x, y, z}{The original data.}
}
\description{
Function for computation of the trinormal ROC surface.
}
\details{
This function takes three-class ROC data and computes the three
 dimentional surface using the R-package \code{rgl}. The ROC surface is
 defined as

 \deqn{z = ROCs(t_-,t_+) = F_0(c_+) - F_0(c_-)=F_0(G_+^{-1}(t_+) )
 -F_0(F_-^{-1}(t_-) ),}

 where \eqn{c_-, c_+} are the two cut-off points and \eqn{F_-, F_0, F_+} the
 cdf of the three classes with \eqn{G = 1-F}.
}
\examples{
data(cancer)
x1 <- with(cancer, cancer[trueClass=="healthy", 8])
y1 <- with(cancer, cancer[trueClass=="intermediate", 8])
z1 <- with(cancer, cancer[trueClass=="diseased", 8])

rocsurf.trin(x1, y1, z1)
}
\references{
Xiong, C., G. Van Belle, et al. (2006). Measuring and estimating
  diagnostic accuracy when there are three ordinal diagnostic groups.
  \emph{Statistics in Medicine} 25(7), 1251–1273.
}
