% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triptych.R
\name{triptych}
\alias{triptych}
\title{Evaluation of forecasts using a Triptych}
\usage{
triptych(x, y_var = "y", ..., y = NULL)
}
\arguments{
\item{x}{A data frame, list, matrix, or other object that can be coerced to a tibble. Contains numeric forecasts, and observations (optional).}

\item{y_var}{A variable in \code{x} that contains observations. Specified as the argument \code{var}in \code{\link[dplyr:pull]{dplyr::pull()}}.}

\item{...}{Additional arguments passed to \code{\link[=murphy]{murphy()}}, \code{\link[=reliability]{reliability()}}, \code{\link[=roc]{roc()}}, and \code{\link[=mcbdsc]{mcbdsc()}}.}

\item{y}{A numeric vector of observations. If supplied, overrides \code{y_var}. Otherwise, defaults to \code{dplyr::pull(x, y_var)}.}
}
\value{
A \code{triptych} object, that is a tibble subclass, and contains five columns:
\itemize{
\item \code{forecast}: Contains the names.
\item \code{murphy}: Contains a \code{vctrs_vctr} subclass of Murphy curves.
\item \code{reliability}: Contains a \code{vctrs_vctr} subclass of reliability curves.
\item \code{roc}: Contains a \code{vctrs_vctr} subclass of ROC curves.
\item \code{mcbdsc}: Contains a \code{vctrs_vctr} subclass of score decompositions.
}
}
\description{
A triptych visualizes three important aspects of predictive performance:
Economic utility via Murphy curves, miscalibration via reliability curves,
and discrimination ability via ROC curves.
The \code{triptych} S3 class has plotting methods for \code{ggplot2}.
}
\examples{
data(ex_binary, package = "triptych")

tr <- triptych(ex_binary)
identical(tr, triptych(ex_binary, y))
identical(tr, triptych(ex_binary, 1))
tr

# 1. Choose 4 predictions
# 2. Add consistency bands (for reliability curves)
#    (Bootstrap resampling is expensive, the number of bootstrap samples
#     is small to keep execution times short)
# 3. Create patchwork object
# 4. Adjust the title of the legend
dplyr::slice(tr, 1, 3, 6, 9) |>
  add_consistency(level = 0.9, method = "resampling_Bernoulli", n_boot = 20) |>
  autoplot() &
  ggplot2::guides(colour = ggplot2::guide_legend("Forecast"))

}
\seealso{
Vector class constructors: \code{\link[=murphy]{murphy()}}, \code{\link[=reliability]{reliability()}}, \code{\link[=roc]{roc()}}, \code{\link[=mcbdsc]{mcbdsc()}}

Adding uncertainty quantification: \code{\link[=add_consistency]{add_consistency()}}, \code{\link[=add_confidence]{add_confidence()}}

Visualization: \code{\link[=plot.triptych]{plot.triptych()}}, \code{\link[=autoplot.triptych]{autoplot.triptych()}}
}
