% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit_lmem}
\alias{fit_lmem}
\title{Fit Linear Mixed-Effects Model to Simulated Ratings}
\usage{
fit_lmem(.data, main_effect = FALSE)
}
\arguments{
\item{.data}{Data frame, with the format as resulting from a call
to \code{\link{gen_data}}.}

\item{main_effect}{Whether to test the main effect of repetition
(TRUE) or the repetition-by-interval interaction (FALSE; the
default).}
}
\value{
A vector, with the following elements.
\describe{
  \item{\code{(Intercept)}}{Fixed-effects estimate of the intercept.}
  \item{\code{R}}{Fixed-effects estimate of the main effect of repetition.}
  \item{\code{I1}}{Fixed-effects estimate of the main effect of interval (1).}
  \item{\code{I2}}{Fixed-effects estimate of the main effect of interval (2).}
  \item{\code{I3}}{Fixed-effects estimate of the main effect of interval (3).}
  \item{\code{R:I1}}{Fixed-effects estimate of the interaction (1).}
  \item{\code{R:I2}}{Fixed-effects estimate of the interaction (2).}
  \item{\code{R:I3}}{Fixed-effects estimate of the interaction (3).}
  \item{dev1}{Deviance for the model including the effect(s) of interest.}
  \item{dev2}{Deviance for the model excluding the effect(s) of interest.}
  \item{chisq_RI}{Chi-square value for the likelihood ratio test.}
  \item{p_RI}{Associated p-value.}
  \item{m1_singular}{Whether the covariance matrix for model 1 was singular.}
  \item{m2_singular}{Whether the covariance matrix for model 2 was singular.}
  \item{m1_conv}{Whether model 1 converged.}
  \item{m2_conv}{Whether model 2 converged.}
}
}
\description{
Fit a linear mixed-effects model (LMM) to simulated ratings data.
}
\details{
This function is used to estimate parameters for power
  analysis with simulated data. \code{fit_lmem} fits a linear-mixed
  effects model to the data with \code{\link[lme4]{lmer}} and tests
  the specified effect (interaction or main effect) using a
  likelihood-ratio test. If the interaction is to be tested, the
  following two models are compared.

\code{trating ~ R * (I1 + I2 + I3) +
   (1 + R:I1 + R:I2 + R:I3 || subj_id) +
   (1 + R:I1 + R:I2 + R:I3 || stim_id)}

\code{trating ~ R + I1 + I2 + I3 +
   (1 + R:I1 + R:I2 + R:I3 || subj_id) +
   (1 + R:I1 + R:I2 + R:I3 || stim_id)}.

If the main effect is to be tested, then the following two models
are compared.

\code{trating ~ R * (I1 + I2 + I3) +
   (1 + R || subj_id) +
   (1 + R || stim_id)}

\code{trating ~ I1 + I2 + I3 + R:I1 + R:I2 + R:I3) +
   (1 + R || subj_id) +
   (1 + R || stim_id)}.
}
\examples{
set.seed(62)
dat <- gen_data(40) 
fit_lmem(dat, TRUE) # test main effect

}
\seealso{
\code{\link{gen_data}}, \code{\link{power_sim}}.
}
