\name{fitted}

\alias{fitted}

\alias{fitted.nlVar}

\encoding{latin1}

\title{fitted method for objects of class nlVar, i.e. VAR and VECM models.}

\description{
  Returns the fitted values of the model, either as computed in the model, or back to the original series level. 
}

\usage{
\method{fitted}{nlVar}(object, level=c("model", "original"),...)	
}
\arguments{
  \item{object}{An object of class \sQuote{nlVar}; generated by \code{\link{VECM}} or \code{\link{lineVar}}.} 
  \item{level}{How to return the fitted values. See below.} 
  \item{\dots}{Currently not used.}
}
\details{

In case of a VAR in differences, in ADF specification, or a VECM, the fitted values are actually in differences. With the option \code{level="original"}, 
the function returns the series in the original level. 

For VAR in levels, the two arguments are evidently the same and hence it is not taken into account, returning a warning. 

}

\value{
  A matrix.
}

\author{Matthieu Stigler}


\examples{

## estimate models
data(barry)

ve <- VECM(barry, lag=2)
va <- lineVar(barry, lag=1)
va_diff <- lineVar(barry, lag=1, I="diff")
va_ADF <- lineVar(barry, lag=1, I="ADF")


## get fitted values:
tail(fitted(ve))
tail(fitted(ve, level="original"))

tail(fitted(va))
tail(fitted(object=va, level="original"))

tail(fitted(va_diff))
tail(fitted(object=va_diff, level="original"))

tail(fitted(va_ADF))
tail(fitted(object=va_ADF, level="original"))

}

\keyword{regression}
