% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smaniplot.r
\name{LjungBoxPierceTest}
\alias{LjungBoxPierceTest}
\title{\code{LjungBoxPierceTest} determines the test statistic and p values for several lags  for a residual series}
\usage{
LjungBoxPierceTest(y, n.par = 0, maxlag = 24)
}
\arguments{
\item{y}{the series of residuals, a vector or a time series}

\item{n.par}{number of parameters which had been estimated}

\item{maxlag}{maximal lag up to which the test statistic is computed}
}
\value{
BT     matrix with columns:  
                 lags,   degrees of freedom,    test statistic,   p-value
}
\description{
\code{LjungBoxPierceTest} determines the test statistic and p values for several lags  for a residual series
}
\examples{
data(COFFEE)
out <- arima(COFFEE,order=c(1,0,0))
BT <- LjungBoxPierceTest(out$residuals,1,20)

}
