% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hac.r
\name{HAC}
\alias{HAC}
\title{HAC Covariance Matrix Estimation
\code{HAC}  computes the central quantity (the meat) in the HAC covariance matrix estimator, also called
sandwich estimator. HAC is the abbreviation for "heteroskedasticity and autocorrelation consistent".}
\source{
Heberle, J. and Sattarhoff, C. (2017) <doi:10.3390/econometrics5010009>  "A Fast Algorithm for the Computation of HAC
   Covariance Matrix Estimators"
}
\usage{
HAC(mcond, method = "Bartlett", bw)
}
\arguments{
\item{mcond}{a q-dimensional multivariate time series. In the case of OLS regression with q regressors mcond 
contains the series of the form regressor*residual (see example below).}

\item{method}{kernel function, choose between "Truncated", "Bartlett", "Parzen", "Tukey-Hanning", "Quadratic Spectral".}

\item{bw}{bandwidth parameter, controls the number of lags considered in the estimation.}
}
\value{
mat      a (q,q)-matrix
}
\description{
HAC Covariance Matrix Estimation
\code{HAC}  computes the central quantity (the meat) in the HAC covariance matrix estimator, also called
sandwich estimator. HAC is the abbreviation for "heteroskedasticity and autocorrelation consistent".
}
\examples{
 
data(MUSKRAT)
y <- ts(log10(MUSKRAT))
n <- length(y)
t <- c(1:n)
t2 <- t^2
out2 <- lm(y ~ t +t2)
mat_xu <- matrix(c(out2$residuals,t*out2$residuals, t2*out2$residuals),nrow=62,ncol=3)
hac <- HAC(mat_xu, method="Bartlett", 4)

mat_regr<- matrix(c(rep(1,62),t,t2),nrow=62,ncol=3)
mat_q <- t(mat_regr)\%*\%mat_regr/62
vcov_HAC <- solve(mat_q)\%*\%hac\%*\%solve(mat_q)/62
# vcov_HAC is the HAC covariance matrix estimation for the OLS coefficients. 
}
