% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdqr.R
\name{ddist}
\alias{ddist}
\alias{pdist}
\alias{qdist}
\alias{rdist}
\title{Distributions pqdr wrapper}
\usage{
ddist(
  distribution = "norm",
  x,
  mu = 0,
  sigma = 1,
  skew = 1,
  shape = 5,
  lambda = -0.5,
  log = FALSE
)

pdist(
  distribution = "norm",
  q,
  mu = 0,
  sigma = 1,
  skew = 1,
  shape = 5,
  lambda = -0.5,
  lower_tail = TRUE,
  log = FALSE
)

qdist(
  distribution = "norm",
  p,
  mu = 0,
  sigma = 1,
  skew = 1,
  shape = 5,
  lambda = -0.5,
  lower_tail = TRUE,
  log = FALSE
)

rdist(
  distribution = "norm",
  n,
  mu = 0,
  sigma = 1,
  skew = 1,
  shape = 5,
  lambda = -0.5
)
}
\arguments{
\item{distribution}{a valid distribution.}

\item{x, q}{vector of quantiles.}

\item{mu}{mean.}

\item{sigma}{standard deviation.}

\item{skew}{skew parameter.}

\item{shape}{shape parameter.}

\item{lambda}{additional shape parameter for the Generalized Hyperbolic
distribution.}

\item{log}{(logical) if TRUE, probabilities p are given as log(p).}

\item{lower_tail}{if TRUE (default), probabilities are \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
d gives the density, p gives the distribution function, q gives the quantile function
and r generates random deviates. Output depends on x or q length, or n for the random number
generator
}
\description{
Density, distribution, quantile function and random number
generation for all the distributions in the package.
}
