% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-classes.r
\docType{class}
\name{ADE-class}
\alias{ADE-class}
\title{Arbitrated Dynamic Ensemble}
\description{
Arbitrated Dynamic Ensemble (ADE) is an ensemble approach
for adaptively combining forecasting models. A metalearning
strategy is used that specializes base models
across the time series. Each meta-learner is specifically
designed to model how apt its base counterpart is to make
a prediction for a given test example. This is accomplished
by analysing how the error incurred by a given learning model
relates to the characteristics of the data. At test time,
the base-learners are weighted according to their degree
of competence in the input observation, estimated by the
predictions of the meta-learners.
}
\section{Slots}{

\describe{
\item{\code{base_ensemble}}{object of class \code{\link{base_ensemble-class}}.
It contains the base models used that can be used for predicting
new data or forecasting future values;}

\item{\code{meta_model}}{a list containing the meta models, one for
each base model. The meta-models are random forests;}

\item{\code{form}}{formula;}

\item{\code{specs}}{object of class \code{\link{model_specs-class}}. Contains
the parameter setting information for training the
base models;}

\item{\code{lambda}}{window size. Number of observations to compute
the recent performance of the base models, according to the
committee ratio \strong{omega}. Essentially, the top \emph{omega}
models are selected and weighted at each prediction instance, according
to their performance in the last \emph{lambda} observations.
Defaults to 50 according to empirical experiments;}

\item{\code{omega}}{committee ratio size. Essentially, the top \emph{omega} * 100
percent of models are selected and weighted at each prediction instance, according
to their performance in the last \emph{lambda} observations.
Defaults to .5 according to empirical experiments;}

\item{\code{select_best}}{Logical. If true, at each prediction time,
a single base model is picked to make a prediction. The picked
model is the one that has the lowest loss prediction from
the meta models. Defaults to FALSE;}

\item{\code{all_models}}{Logical. If true, at each prediction time,
all base models are picked to make a prediction. The
models are weighted according to their predicted loss
and the \code{aggregation} function. Defaults to FALSE;}

\item{\code{aggregation}}{Type of aggregation used to combine the
predictions of the base models. The options are:
\describe{
 \item{softmax}{default}
 \item{erfc}{the complementary Gaussian error function}
 \item{linear}{a linear scaling}
}}

\item{\code{sequential_reweight}}{Besides ensemble heterogeneity we encourage diversity
explicitly during the aggregation of the output of experts.
This is achieved by taking into account not only predictions
of performance produced by the arbiters, but also the
correlation among experts in a recent window of observations.}

\item{\code{recent_series}}{the most recent \code{lambda} observations.}

\item{\code{out_of_bag}}{Out of bag observations used to train arbiters.}
}}

\examples{
specs <- model_specs(
  learner = c("bm_ppr", "bm_glm", "bm_mars"),
  learner_pars = list(
    bm_glm = list(alpha = c(0, .5, 1)),
    bm_svr = list(kernel = c("rbfdot", "polydot"),
                  C = c(1, 3)),
    bm_ppr = list(nterms = 4)
  )
)

data("water_consumption")
train <- embed_timeseries(water_consumption, 5)
train <- train[1:300, ] # toy size for checks

model <- ADE(target ~., train, specs)

}
\references{
Cerqueira, Vitor; Torgo, Luis; Pinto, Fabio;
and Soares, Carlos. "Arbitrated Ensemble for Time Series
Forecasting" to appear at: Joint European Conference on Machine Learning and
Knowledge Discovery in Databases. Springer International
Publishing, 2017.

V. Cerqueira, L. Torgo, and C. Soares, “Arbitrated ensemble for
solar radiation forecasting,” in International Work-Conference on
Artificial Neural Networks. Springer, Cham, 2017, pp. 720–732
}
\seealso{
\code{\link{model_specs-class}} for setting up the ensemble parameters
for an \strong{ADE} model; \code{\link{forecast}} for the forecasting method
that uses an \strong{ADE} model for forecasting future values;
\code{\link{predict}} for the method that predicts new held out observations;
\code{\link{update_weights}} for the method used to update the
weights of an \strong{ADE} model between successive predict or forecast calls;
\code{\link{update_ade_meta}} for updating (retraining) the meta models
of an \strong{ADE} model; \code{\link{update_base_models}} for
the updating (retraining) the base models of an \strong{ADE} ensemble (and respective
weights); \code{\link{ade_hat-class}} for the object that results from
predicting with an \strong{ADE} model; and \code{\link{update_ade}} to update an ADE
model, combining functions \strong{update_base_models}, \strong{update_meta_ade}, and
\strong{update_weights}.
}
\keyword{internal}
