% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build-base-ensemble.r
\name{build_base_ensemble}
\alias{build_base_ensemble}
\title{Wrapper for creating an ensemble}
\usage{
build_base_ensemble(form, data, specs, num_cores = 1)
}
\arguments{
\item{form}{formula;}

\item{data}{data.frame for training the predictive models;}

\item{specs}{object of class \code{\link{model_specs-class}}. Contains the information
about the parameter setting of the models to train.}

\item{num_cores}{number of cores}
}
\value{
An S4 class with the following slots:
\strong{base_models}, a list containing the trained models;
\strong{pre_weights}, a numeric vector describing the weights
of the base models according to their performance in the training
data; and \strong{colnames}, the column names of the data, used for
reference.
}
\description{
Using the parameter specifications from
\code{\link{model_specs-class}}, this function trains
a set of regression models.
}
\examples{
data("water_consumption")
dataset <- embed_timeseries(water_consumption, 5)
specs <- model_specs(c("bm_ppr","bm_svr"), NULL)
M <- build_base_ensemble(target ~., dataset, specs, 1)

}
