% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_example}
\alias{plot_example}
\title{Plot an example used in a prediction of a grnnForecast object}
\usage{
plot_example(forecast, position, h = 1)
}
\arguments{
\item{forecast}{The grnnForecast object.}

\item{position}{An integer. It is an ordinal number indicating what training
pattern to plot. For instance, if \code{position} is 1 it means that the
training pattern with the greatest weight should be plotted. If
\code{position} is 2 the training pattern with the second greatest weight
is plotted and so on.}

\item{h}{An integer. This value is only useful when the recursive strategy is
being used. It indicates the forecasting horizon}
}
\value{
A ggplot object representing an example used in the prediction.
}
\description{
This function is useful to see how the forecast has been computed. An ordinal
specifying the order of the weight has to be supplied and the function plots
the training pattern associated with that ordinal.
}
\examples{
pred <- grnn_forecasting(USAccDeaths, h = 12, lags = 1:12, sigma = 50)
library(ggplot2)
plot_example(pred, 1)
}
