% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecasting.R
\name{predict.grnnForecast}
\alias{predict.grnnForecast}
\title{Predict method for GRNN models for time series forecasting.}
\usage{
\method{predict}{grnnForecast}(object, h, ...)
}
\arguments{
\item{object}{a \code{grnnForecast} object obtained by a call to the
\code{\link{grnn_forecasting}} function.}

\item{h}{an integer. The forecasting horizon.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a \code{grnnForecast} object with the prediction and information
about the GRNN model, see the documentation of \code{\link{grnn_forecasting}}
for the structure of \code{grnnForecast} objects.
}
\description{
Predicted values based on a GRNN model for time series forecasting.
}
\details{
If the models uses the MIMO strategy for multiple-step ahead prediction,
the forecasting horizon is fixed to the model forecasting horizon.
}
\examples{
pred <- grnn_forecasting(UKgas, h = 4, msas = "MIMO")
new_pred <- predict(pred, h = 4)
print(new_pred$prediction)
plot(new_pred) # To see a plot with the forecast

}
