% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/window.R
\name{tile}
\alias{tile}
\alias{tile_lst}
\alias{tile_dfr}
\alias{tile_dfc}
\alias{tiler}
\title{Tiling window calculation}
\usage{
tile(x, .f, ..., size = 1)

tile_lst(x, .f, ..., size = 1)

tile_dfr(x, .f, ..., size = 1, .id = NULL)

tile_dfc(x, .f, ..., size = 1)

tiler(x, size = 1)
}
\arguments{
\item{x}{A vector of numerics, or data frame. If a data frame, row-wise rolling
window is performed.}

\item{.f}{A function or one-sided formula using purrr-like syntax. If a
formula, it is converted to a function.}

\item{...}{Additional arguments passed on to \code{.f}.}

\item{size}{An integer for window size.}

\item{.id}{If not \code{NULL} a variable with this name will be created giving
either the name or the index of the data frame, which is passed to
\link[dplyr:bind_rows]{dplyr::bind_rows}.}
}
\description{
Tiling window without overlapping observations:
\itemize{
\item \code{tile()} always returns a vector of numerics
\item \code{tile_lst()} returns a list
\item \code{tile_dfr()} and \code{tile_dfc()} return data frame using row-binding and
column-binding
\item \code{tiler()} splits the input \code{x} to a list according to the window size.
}
}
\examples{
# tiling over a vector ----
x <- 1:10
tile(x, sum, size = 3)
tile(x, ~ sum(.), size = 3)
tiler(x, size = 3)

# tiling over a 2-day window for hourly data ----
\dontrun{
pedestrian \%>\% 
  split(.$Sensor) \%>\% 
  purrr::map_dfr(~ tile_dfr(., ~ quantile(.$Count), size = 48))
}
}
\seealso{
\link{slide} for sliding window with overlapping observations;
\link{stretch} for expanding more observations
}
