% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-verbs.R
\name{group_by.tbl_ts}
\alias{group_by.tbl_ts}
\alias{ungroup.grouped_ts}
\title{Group by one or more variables}
\usage{
\method{group_by}{tbl_ts}(.data, ..., add = FALSE)

\method{ungroup}{grouped_ts}(x, ...)
}
\arguments{
\item{.data}{A tsibble.}

\item{...}{Variables to group by. All tbls accept variable names.
Some tbls will accept functions of variables. Duplicated groups
will be silently dropped.}

\item{add}{When \code{add = FALSE}, the default, \code{group_by()} will
override existing groups. To add to the existing groups, use
\code{add = TRUE}.}

\item{x}{A (grouped) tsibble.}
}
\description{
Group by one or more variables
}
\examples{
data(tourism)
tourism \%>\%
  group_by(Region, State) \%>\%
  summarise(geo_trips = sum(Trips))
}
\seealso{
\link[dplyr:group_by]{dplyr::group_by}

\link[dplyr:ungroup]{dplyr::ungroup}
}
