% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-tsibble.R
\name{is_duplicated}
\alias{is_duplicated}
\alias{are_duplicated}
\alias{duplicates}
\title{Test duplicated observations determined by key and index variables}
\usage{
is_duplicated(data, key = id(), index)

are_duplicated(data, key = id(), index, from_last = FALSE)

duplicates(data, key = id(), index)
}
\arguments{
\item{data}{A data frame for creating a tsibble.}

\item{key}{Variable(s) that define unique time indices, used in conjunction
with the helper \code{\link[=id]{id()}}. If a univariate time series (without an explicit key),
simply call \code{id()}.}

\item{index}{A bare (or unquoted) variable to specify the time index variable.}

\item{from_last}{\code{TRUE} does the duplication check from the last of identical
elements.}
}
\description{
\itemize{
\item \code{is_duplicated()}: a logical scalar if the data exist duplicated observations.
\item \code{are_duplicated()}: a logical vector, the same length as the row number of \code{data}.
\item \code{duplicates()}: identical key-index data entries.
}
}
\examples{
harvest <- tibble(
  year = c(2010, 2011, 2013, 2011, 2012, 2014, 2014),
  fruit = c(rep(c("kiwi", "cherry"), each = 3), "cherry"),
  kilo = sample(1:10, size = 7)
)
is_duplicated(harvest, key = id(fruit), index = year)
are_duplicated(harvest, key = id(fruit), index = year)
are_duplicated(harvest, key = id(fruit), index = year, from_last = TRUE)
duplicates(harvest, key = id(fruit), index = year)
}
