% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yearweek.R
\name{yearweek}
\alias{yearweek}
\alias{is_yearweek}
\alias{is_53weeks}
\title{Represent year-week (ISO) starting on Monday}
\usage{
yearweek(x)

is_yearweek(x)

is_53weeks(year)
}
\arguments{
\item{x}{Other object.}

\item{year}{A vector of years.}
}
\value{
year-week (\code{yearweek}) objects.

\code{TRUE}/\code{FALSE} if the year has 53 ISO weeks.
}
\description{
\lifecycle{stable}

Create or coerce using \code{yearweek()}.
}
\section{Display}{

Use \code{format()} to display \code{yearweek}, \code{yearmonth}, and \code{yearquarter} objects
in required formats.
Please see \code{\link[=strptime]{strptime()}} details for supported conversion specifications.
}

\examples{
# coerce POSIXct/Dates to yearweek
x <- seq(as.Date("2016-01-01"), as.Date("2016-12-31"), by = "1 week")
yearweek(x)

# parse characters
yearweek(c("2018 W01", "2018 Wk01", "2018 Week 1"))

# creat an empty yearweek container
yearweek()

# seq() and arithmetic
wk1 <- yearweek("2017 W50")
wk2 <- yearweek("2018 W12")
seq(from = wk1, to = wk2, by = 2)
wk1 + 0:9

# display formats
format(c(wk1, wk2), format = "\%V/\%Y")

# units since 1969-12-29
as.double(yearweek("1969 W41") + 0:24)
is_53weeks(2015:2016)
}
\seealso{
Other index functions: 
\code{\link{yearmonth}()},
\code{\link{yearquarter}()}
}
\concept{index functions}
