% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-verbs.R
\name{tsibble-tidyverse}
\alias{tsibble-tidyverse}
\title{Tidyverse methods for tsibble}
\description{
Current dplyr verbs that tsibble has support for:
\itemize{
\item \code{\link[dplyr:filter]{dplyr::filter()}}, \code{\link[dplyr:slice]{dplyr::slice()}}, \code{\link[dplyr:arrange]{dplyr::arrange()}}
\item \code{\link[dplyr:select]{dplyr::select()}}, \code{\link[dplyr:transmute]{dplyr::transmute()}}, \code{\link[dplyr:mutate]{dplyr::mutate()}}, \code{\link[dplyr:relocate]{dplyr::relocate()}},
\code{\link[dplyr:summarise]{dplyr::summarise()}}, \code{\link[dplyr:group_by]{dplyr::group_by()}}
\item \code{\link[dplyr:mutate-joins]{dplyr::left_join()}}, \code{\link[dplyr:mutate-joins]{dplyr::right_join()}}, \code{\link[dplyr:mutate-joins]{dplyr::full_join()}},
\code{\link[dplyr:mutate-joins]{dplyr::inner_join()}}, \code{\link[dplyr:filter-joins]{dplyr::semi_join()}}, \code{\link[dplyr:filter-joins]{dplyr::anti_join()}},
\code{\link[dplyr:nest_join]{dplyr::nest_join()}}
\item \code{\link[dplyr:bind_rows]{dplyr::bind_rows()}}, \code{\link[dplyr:bind_cols]{dplyr::bind_cols()}}
}

Current tidyr verbs that tsibble has support for:
\itemize{
\item \code{\link[tidyr:pivot_longer]{tidyr::pivot_longer()}}, \code{\link[tidyr:pivot_wider]{tidyr::pivot_wider()}},
\code{\link[tidyr:gather]{tidyr::gather()}}, \code{\link[tidyr:spread]{tidyr::spread()}}
\item \code{\link[tidyr:nest]{tidyr::nest()}}, \code{\link[tidyr:fill]{tidyr::fill()}}, \code{\link[tidyr:drop_na]{tidyr::drop_na()}}
}
}
\section{Column-wise verbs}{

\itemize{
\item The index variable cannot be dropped for a tsibble object.
\item When any key variable is modified, a check on the validity of the resulting
tsibble will be performed internally.
\item Use \code{as_tibble()} to convert tsibble to a general data frame.
}
}

\section{Row-wise verbs}{

A warning is likely to be issued, if observations are not arranged in
past-to-future order.
}

\section{Join verbs}{

Joining with other data sources triggers the check on the validity of the
resulting tsibble.
}

\examples{
library(dplyr, warn.conflicts = FALSE)
# `summarise()` a tsibble always aggregates over time
# Sum over sensors
pedestrian \%>\%
  index_by() \%>\%
  summarise(Total = sum(Count))
# shortcut
pedestrian \%>\%
  summarise(Total = sum(Count))
# Back to tibble
pedestrian \%>\%
  as_tibble() \%>\%
  summarise(Total = sum(Count))

library(tidyr)
stocks <- tsibble(
  time = as.Date("2009-01-01") + 0:9,
  X = rnorm(10, 0, 1),
  Y = rnorm(10, 0, 2),
  Z = rnorm(10, 0, 4)
)
(stocksm <- stocks \%>\%
  pivot_longer(-time, names_to = "stock", values_to = "price"))
stocksm \%>\%
  pivot_wider(names_from = stock, values_from = price)
}
