% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdts_predict.R
\name{sdts.f.score}
\alias{sdts.f.score}
\title{Computes the F-Score of a SDTS prediction}
\usage{
sdts.f.score(gtruth, pred, beta = 1)
}
\arguments{
\item{gtruth}{a \code{vector} of \code{logical}. Ground truth annotation.}

\item{pred}{a \code{vector} of \code{logical}. Predictied annotation from \code{\link[=sdts.predict]{sdts.predict()}}}

\item{beta}{a \code{numeric}. See details. (default is \code{1}).}
}
\value{
Returns a \code{list} with \code{f.score}, \code{precision} and \code{recall}.
}
\description{
Computes the F-Score of a SDTS prediction.
}
\details{
\code{beta} is used to balance F-score towards recall (\code{>1}) or precision (\code{<1}).
}
\examples{
# This is a fast toy example and results are useless. For a complete result, run the code inside
#'Not run' section below.
w <- c(110, 220)
subs <- 11000:20000
tr_data <- test_data$train$data[subs]
tr_label <- test_data$train$label[subs]
te_data <- test_data$test$data[subs]
te_label <- test_data$test$label[subs]
model <- sdts.train(tr_data, tr_label, w, verbose = 0)
predict <- sdts.predict(model, te_data, round(mean(w)))
sdts.f.score(te_label, predict, 1)
\dontrun{
windows <- c(110, 220, 330)
model <- sdts.train(test_data$train$data, test_data$train$label, windows)
predict <- sdts.predict(model, test_data$test$data, round(mean(windows)))
sdts.f.score(test_data$test$label, predict, 1)
}

}
\seealso{
Other SDTS: \code{\link{sdts.predict}},
  \code{\link{sdts.train}}
}
\concept{SDTS}
