% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdts-train.R
\name{sdts_train}
\alias{sdts_train}
\title{Framework for Scalable Dictionary learning for Time Series (SDTS) training function}
\usage{
sdts_train(data, label, window_size, beta = 1, pat_max = Inf,
  parallel = TRUE, verbose = 2)
}
\arguments{
\item{data}{a \code{vector} of \code{numeric}. Time series.}

\item{label}{a \code{vector} of \code{logical}. Annotations.}

\item{window_size}{an \code{int} or a \code{vector} of \code{int}. Sliding window sizes.}

\item{beta}{a \code{numeric}. See details. (default is \code{1}).}

\item{pat_max}{an \code{int}. Max number of shape features captured. (default is \code{Inf}).}

\item{parallel}{a \code{logical}. Use parallel computation inside (default is \code{TRUE}).}

\item{verbose}{an \code{int}. See details. (Default is \code{2}).}
}
\value{
Returns a list with the learned dictionary \code{score} (estimated score), \code{score_hist}
(history of scores), \code{pattern} (shape features), \code{thold} (threshold values).
}
\description{
This function trains a model that uses a dictionary to predict state changes. Differently from
\code{\link[=fluss]{fluss()}}, it doesn't look for semantic changes (that may be several), but for binary states like
"on" or "off". Think for example that a human annotator is pressing a switch any time he thinks
that the recorded data is relevant, and releases the switch when he thinks the data is noise. This
algorithm will learn the switching points (even better) and try to predict using new data.
}
\details{
\code{beta} is used to balance F-score towards recall (\code{>1}) or precision (\code{<1}). \code{verbose} changes
how much information is printed by this function; \code{0} means nothing, \code{1} means text, \code{2} adds the
progress bar, \code{3} adds the finish sound.
}
\examples{
# This is a fast toy example and results are useless. For a complete result, run the code inside
#'Not run' section below.
w <- c(110, 220)
subs <- 11000:20000
tr_data <- mp_test_data$train$data[subs]
tr_label <- mp_test_data$train$label[subs]
te_data <- mp_test_data$test$data[subs]
te_label <- mp_test_data$test$label[subs]
model <- sdts_train(tr_data, tr_label, w, verbose = 0)
predict <- sdts_predict(model, te_data, round(mean(w)))
sdts_score(predict, te_label, 1)

\dontrun{
windows <- c(110, 220, 330)
model <- sdts_train(mp_test_data$train$data, mp_test_data$train$label, windows)
predict <- sdts_predict(model, mp_test_data$test$data, round(mean(windows)))
sdts_score(predict, mp_test_data$test$label, 1)
}
}
\references{
\itemize{
\item Yeh C-CM, Kavantzas N, Keogh E. Matrix profile IV: Using Weakly Labeled Time Series
to Predict Outcomes. Proc VLDB Endow. 2017 Aug 1;10(12):1802–12.
}

Website: \url{https://sites.google.com/view/weaklylabeled}
}
\seealso{
Other Scalable Dictionaries: \code{\link{sdts_predict}},
  \code{\link{sdts_score}}
}
\concept{Scalable Dictionaries}
