% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var.R
\name{var_test}
\alias{var_test}
\title{Value at Risk and Expected Shortfall Tests}
\usage{
var_test(
  actual,
  forecast,
  x,
  alpha,
  lags = 1,
  boot = FALSE,
  n_boot = 2000,
  ...
)
}
\arguments{
\item{actual}{a series representing the actual value of the series in the
out of sample period.}

\item{forecast}{the forecast values of the series at the quantile
given by alpha (the forecast value at risk).}

\item{x}{the probability integral transformed series (pit).}

\item{alpha}{the quantile level used to calculate the forecast value at risk.}

\item{lags}{the numbers of lags to use for the conditional shortfall test.}

\item{boot}{whether to use bootstrap simulation for estimating the p-values of
the conditional shortfall test.}

\item{n_boot}{the bootstrap replications used to calculate the p-value.}

\item{...}{not currently used.}
}
\value{
An object of class \dQuote{tstest.vares} which has a print and
as_flextable method.
}
\description{
The value at risk coverage and duration tests of
Kupiec (1995) and Christoffersen and Pelletier (1998,2004), and
expected shortfall test of Du and Escanciano (2017).
}
\details{
This is a condensed table of both the \code{\link{var_cp_test}} and
\code{\link{shortfall_de_test}}.
}
\references{
\insertRef{Kupiec1995}{tstests}

\insertRef{Christoffersen1998}{tstests}

\insertRef{Christoffersen2004}{tstests}

\insertRef{Du2017}{tstests}
}
