% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeansbary.R
\name{netsplit}
\alias{netsplit}
\title{Incorporate Point Patterns into a Network}
\usage{
netsplit(network, pplist)
}
\arguments{
\item{network}{an object of class \code{linnet} or \code{lpp}. In the latter case the \code{domain}
component is extracted and any points of the \code{lpp} are ignored.}

\item{pplist}{a list containing (at least) \code{x}- and \code{y}-coordinates of the point patterns,
which will be projected onto the network}
}
\value{
A list containing the following components:
        \item{network}{the new network with all the points added as vertices. Contains also the matrix
        of shortest-path distances between all these points.}
        \item{ppmatrix}{a matrix containing the new vertex-indices of the data point patterns, one column corresponds to one point pattern.} 
        \item{dimensions}{a vector containing the cardinalities of the data point patterns.} 
        \item{nvirtual}{the index of the virtual point.}
}
\description{
Given a network and a list of point patterns on this network, create a new network from all the
vertices of the original network plus all the points in the patterns, splitting any edges that
contain such points into several shorter edges. This function keeps track which vertex-indices 
represent each of the data point patterns. The returned object contains all the components
needed for a call to \code{\link{kmeansbarynet}}.
}
\details{
This function relies heavily on code from the package \code{spatstat} to create the
          new network and efficiently compute all pairwise shortest-path distances between
          the new vertices.
          
          If not all point patterns are of the same size, this function fills up the vertex-indices
          of the smaller patterns with a virtual index that is one larger than the maximal
          index appearing in the new network. This structure is required for 
          calling \code{\link{kmeansbarynet}}.
}
\examples{
# See the example for kmeansbarynet.

}
\seealso{
\code{\link{kmeansbarynet}}
}
\author{
Raoul Müller  \email{raoul.mueller@uni-goettingen.de}\cr
        Dominic Schuhmacher \email{schuhmacher@math.uni-goettingen.de}
}
