% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_comments.R
\name{get_comments}
\alias{get_comments}
\title{Get Comments On a Video}
\usage{
get_comments(video_id = NULL, simplify = TRUE, maxResults = 20,
  textFormat = "html")
}
\arguments{
\item{video_id}{Data Type: Character. ID of the video. Required.}

\item{simplify}{Data Type: Boolean. Default is TRUE. If TRUE, the function returns a data frame. Else a list with all the information returned.}

\item{maxResults}{Data Type: Numeric. Default is 20. Takes values between 20 and 100. Optional.}

\item{textFormat}{Data Type: Character. Default is "html". Only takes "html" or "plainText." Optional.}
}
\value{
Nested named list. The entry \code{items} is a list of comments along with meta information. 
Within each of the \code{items} is an item \code{snippet} which has an item \code{topLevelComment$snippet$textDisplay}
that contains the actual comment.
}
\description{
Get Comments On a Video
}
\examples{
\dontrun{
get_comments(video_id="N708P-A45D0")
}
}
\references{
\url{https://developers.google.com/youtube/v3/docs/}
}

