% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel.R
\name{parallelism}
\alias{parallelism}
\title{Support for parallel processing in tune}
\description{
Support for parallel backends registered with the \link[foreach:foreach]{foreach}
package was deprecated in tune 1.2.1 in favor of the
\link[future:future]{future} package. The package will now raise a warning when:
\enumerate{
\item A parallel backend has been registered with foreach, and
\item No \link[future:plan]{plan} has been specified with future.
}

If parallelism has been configured with both framework, tune will use the
plan specified with future and will not warn. To transition your code from
foreach to future, remove code that registers a foreach \code{Backend}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(doBackend)
registerDoBackend(cores = 4)
}\if{html}{\out{</div>}}

And replace it with:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(future)
plan(multisession, workers = 4)
}\if{html}{\out{</div>}}

See \code{\link[future:plan]{future::plan()}} for possible options other than \code{multisession}.

Note that \pkg{tune} resets the \emph{maximum} limit of memory of global variables
(e.g., attached packages) to be greater than the default when the package is
loaded. This value can be altered using \code{options(future.globals.maxSize)}.
}
