% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tvReg.R
\name{plot.tvsure}
\alias{plot.tvsure}
\alias{plot.tvlm}
\alias{plot.tvar}
\alias{plot.tvplm}
\alias{plot.tvvar}
\alias{plot.tvirf}
\title{Plot Methods for Objects in tvReg}
\usage{
\method{plot}{tvsure}(x, eqs = NULL, vars = NULL, plot.type = c("multiple", "single"), ...)

\method{plot}{tvlm}(x, ...)

\method{plot}{tvar}(x, ...)

\method{plot}{tvplm}(x, ...)

\method{plot}{tvvar}(x, ...)

\method{plot}{tvirf}(
  x,
  obs.index = NULL,
  impulse = NULL,
  response = NULL,
  plot.type = c("multiple", "single"),
  ...
)
}
\arguments{
\item{x}{An object used to select the method.}

\item{eqs}{A vector of integers. Equation(s) number(s) of the coefficients to be plotted.}

\item{vars}{A vector of integers. Variable number(s) of the coefficients to be plotted.}

\item{plot.type}{Character, if multiple all plots are drawn in a single device,
otherwise the plots are shown consecutively.}

\item{...}{Other parameters passed to specific methods.}

\item{obs.index}{Scalar (optional), the time at which the impulse response is plotted.
If left NULL, the mean over the whole period is plotted (this values should be similar to
the estimation using a non time-varying VAR method).}

\item{impulse}{Character  vector (optional) of the impulses, default is all variables.}

\item{response}{Character vector (optional) of the responses, default is all variables.}
}
\description{
Plot methods for objects with class attribute \code{tvlm}, \code{tvar}, \code{tvvar},
\code{tvirf}, \code{tvsure} or \code{tvplm}.
}
\seealso{
\code{\link{tvLM}}, \code{\link{tvAR}}, \code{\link{tvVAR}},
\code{\link{tvSURE}}, \code{\link{tvPLM}}
}
