% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_taxon_attribute.R
\name{is_taxon_attribute}
\alias{is_taxon_attribute}
\alias{is_taxonlevel}
\alias{is_taxontype}
\alias{is_status}
\title{Test of een taxon een bepaald attribuut heeft.}
\usage{
is_taxonlevel(taxa, taxonlevel = NULL)

is_taxontype(taxa, taxontype)

is_status(taxa, status)
}
\arguments{
\item{taxa}{Een vector met taxonnamen}

\item{taxonlevel}{Het taxonlevel dat getest moet worden. Als het niet wordt opgegeven dan
wordt het taxonlevel op "Species gezet". Zie \code{twn::taxonlevels} voor alle mogelijke taxonlevels.
Het taxonlevel is niet hoofdlettergevoelig}

\item{taxontype}{Het taxontype dat getest moet worden. Zie \code{unique(twn_lijst$taxontype)}
voor alle mogelijke taxontypes. Het taxontype is niet hoofdlettergevoelig}

\item{status}{De status die getest moet worden. Zie twn_statuscodes voor alle
mogelijke statussen.}
}
\value{
Een logische vector. Als een taxon ontbreekt of niet in de TWN-lijst voorkomt wordt \code{NA}
geretourneerd.
}
\description{
Deze functies kijken of taxa een bepaald taxonlevel, taxontype of status hebben en
retourneert een logische vector.
}
\examples{

is_taxonlevel(c("Bufo bufo", "Bufo", "Bufonidae", "Buf", NA), "Species")

is_taxontype(c("Bufo bufo", "Abies", "Bufonidae", "Buf", NA), "Amphibia")

is_status(c("Bufo", "Bufo calamita"), 10)

}
