% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/documentation.R,
%   R/two_samples.R
\name{cvm_stat}
\alias{cvm_stat}
\alias{cvm_test}
\title{Cramer-vonMises Test}
\usage{
cvm_stat(a, b, power = 2)

cvm_test(a, b, nboots = 2000, p = default.p)
}
\arguments{
\item{a}{a vector of numbers}

\item{b}{a vector of numbers}

\item{power}{power to raise test stat to}

\item{nboots}{Number of bootstrap iterations}

\item{p}{power to raise test stat to}
}
\value{
Output is a length 2 Vector with test stat and p-value in that order. That vector has 3 attributes -- the sample sizes of each sample, and the number of bootstraps performed for the pvalue.
}
\description{
Cramer-vonMises Test
}
\details{
The CVM test compares two ECDFs by looking at the sum of the squared differences between them -- evaluated at each point in the joint sample. Formally -- if E is the ECDF of sample 1 and F is the ECDF of sample 2, then CVM = SUM_(x in k) (E(x)-F(x))^2 where k is the joint sample. The test p-value is calculated by randomly resampling two samples of the same size using the combined sample. Intuitively the CVM test improves on KS by using the full joint sample, rather than just the maximum distance -- this gives it greater power against shifts in higher moments, like variance changes.
}
\section{Functions}{
\itemize{
\item \code{cvm_stat}: Cramer-Von Mises Test statistic

\item \code{cvm_test}: Permutation based two sample Cramer-Von Mises test
}}

\examples{
vec1 = rnorm(20)
vec2 = rnorm(20,4)
cvm_test(vec1,vec2)
}
