% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tzupdater.R
\name{install_last_tz}
\alias{install_last_tz}
\title{install_last_tz}
\usage{
install_last_tz(
  zic_path = NA,
  target_folder = paste0(tempdir(), "/tzupdater/data/IANA_release"),
  verbose = TRUE
)
}
\arguments{
\item{zic_path}{Optional for Windows: path to the zic compiler (if not in
C:\\Cygwin\\usr\\sbin).}

\item{target_folder}{Optional target folder. Default will be
tzupdater/data/IANA_release as subdirectory of your temp dir.}

\item{verbose}{Print information to the console TRUE/FALSE. Default TRUE.}
}
\value{
None.
}
\description{
Install latest tz database if required, and make it active.\cr\cr
Will stop in case it is not possible to know what the last version is.\cr
If it happens browse IANA website at https://www.iana.org/time-zones and install last version with install_tz(version).\cr
?install_tz for details.
}
\examples{

# Get the latest version available and compile. 
# If your tz database is already the latest, do nothing.
install_last_tz()

# Same, but more verbose.
install_last_tz(verbose = TRUE)

# On Windows: install latest tz database, with Cygwin installed in c:\\Cygwin.
install_last_tz(zic_path="C:\\\\Cygwin\\\\usr\\\\sbin")
}
