% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAINest.R
\name{iterate_more}
\alias{iterate_more}
\title{Maximum likelihood estimation of GMAR, StMAR or G-StMAR model with preliminary estimates}
\usage{
iterate_more(gsmar, maxit = 100)
}
\arguments{
\item{gsmar}{object of class \code{'gsmar'} created with the function \code{fitGSMAR} or \code{GSMAR}.}

\item{maxit}{maximum number of iterations in the variable metric algorithm.}
}
\value{
Returns an object of class \code{'gsmar'} defining the estimated model. Can be used
  to work with other functions provided in \code{uGMAR}.
}
\description{
\code{iterate_more} uses variable metric algorithm to finalize maximum likelihood
 estimation of GMAR, StMAR or G-StMAR model (object of class \code{'gsmarar'}) which already has preliminary estimates.
}
\details{
The main purpose of \code{iterate_more} is to provide a simple and convenient tool to finalize
  the estimation when the maximum number of iterations is reached when estimating a model with the
  main estimation function \code{fitGSMAR}. It's just a simple wrapper around function \code{optim}
  from the package \code{stats} and \code{GSMAR} from the package \code{uGMAR}.
}
\examples{
\donttest{
# Estimate GMAR model with only 50 generations of genetic algorithm and
# only 1 iteration in variable metric algorithm
fit12 <- fitGSMAR(logVIX, 1, 2, maxit=1, ngen=50, ncalls=3)
fit12

# Iterate more since iteration limit was reached
fit12 <- iterate_more(fit12)
fit12
}
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Meitz M., Preve D., Saikkonen P. 2018. A mixture autoregressive model based on Student's t-distribution.
           arXiv:1805.04010 \strong{[econ.EM]}.
   \item There are currently no published references for the G-StMAR model, but it's a straightforward generalization with
           theoretical properties similar to the GMAR and StMAR models.
 }
}
\seealso{
\code{\link{fitGSMAR}}, \code{\link{GSMAR}}, \code{\link{stmar_to_gstmar}}, \code{\link{optim}}
}
