% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictMethod.R
\name{predict.gsmar}
\alias{predict.gsmar}
\title{Forecast GMAR, StMAR, or G-StMAR process}
\usage{
\method{predict}{gsmar}(
  object,
  ...,
  n_ahead,
  nsimu = 10000,
  pi = c(0.95, 0.8),
  pred_type = c("median", "mean", "cond_mean"),
  pi_type = c("two-sided", "upper", "lower", "none"),
  plot_res = TRUE,
  mix_weights = TRUE,
  nt
)
}
\arguments{
\item{object}{object of class \code{'gsmar'} created with function \code{fitGSMAR} or \code{GSMAR}.}

\item{...}{additional arguments passed to \code{grid} (ignored if \code{plot_res==FALSE}).}

\item{n_ahead}{a positive integer specifying how many steps in the future should be forecasted.}

\item{nsimu}{a positive integer specifying to how many simulations the forecast should be based on.}

\item{pi}{a numeric vector specifying confidence levels for the prediction intervals.}

\item{pred_type}{should the prediction be based on sample "median" or "mean"? Or should it
be one-step-ahead forecast based on the exact conditional mean (\code{"cond_mean"})? prediction
intervals won't be calculated if the exact conditional mean is used.}

\item{pi_type}{should the prediction intervals be "two-sided", "upper", or "lower"?}

\item{plot_res}{a logical argument defining whether the forecast should be plotted or not.}

\item{mix_weights}{\code{TRUE} if forecasts for mixing weights should be plotted, \code{FALSE} in not.}

\item{nt}{a positive integer specifying the number of observations to be plotted
along with the prediction. Default is \code{round(length(data)*0.15)}.}
}
\value{
Returns a class \code{'gsmarpred'} object containing, among the specifications,...
 \describe{
   \item{$pred}{Point forecasts}
   \item{$pred_ints}{Prediction intervals}
   \item{$mix_pred}{Point forecasts for mixing weights}
   \item{mix_pred_ints}{Individual prediction intervals for mixing weights, as \code{[, , m]}, m=1,..,M.}
 }
}
\description{
\code{predict.gsmar} forecasts the specified GMAR, StMAR, or G-StMAR process by using the given
 data to simulate its possible future values. For one-step forecasts using the exact formula for conditional
 mean is supported.
}
\details{
\code{predict.gsmar} uses the last \code{p} values of the data to simulate \code{nsimu}
 possible future values for each step-ahead. The point prediction is then obtained by calculating
 the sample median or mean for each step and the prediction intervals are obtained from the
 empirical fractiles.

 The function \code{simulateGSMAR} can also be used directly for quantile based forecasting.
}
\examples{
\donttest{
## These examples take approximately 30 seconds to run.

# G-StMAR model with one GMAR type and one StMAR type regime
fit42gs <- fitGSMAR(M10Y1Y, p=4, M=c(1, 1), model="G-StMAR",
                    ncalls=1, seeds=4)

# Forecast 12 steps ahead based on 10000 simulated sample paths, prediction
# interval confidence levels 0.95 and 0.8, prediction based on sample median,
# and two-sided prediction intevals:
mypred <- predict(fit42gs, n_ahead=12, nsimu=10000, pi=c(0.95, 0.8),
                  pred_type="median", pi_type="two-sided")
mypred
plot(mypred)

# Forecast 24 steps ahead based on 1000 simulated sample paths, prediction
# interval confidence level 0.99 and 0.9, prediction based on sample mean,
# and upper prediction intevals:
mypred2 <- predict(fit42gs, n_ahead=24, nsimu=1000, pi=c(0.99, 0.9),
                   pred_type="mean", pi_type="upper")

# Forecast 24 steps ahead based on 1000 simulated sample paths, prediction
# interval confidence level 0.99, 0.95, 0.9 and 0.8, prediction based on
# sample median, and lower prediction intevals:
mypred3 <- predict(fit42gs, n_ahead=24, nsimu=1000, pi=c(0.99, 0.95, 0.9, 0.8),
                   pred_type="median", pi_type="lower")

# GMAR model
params12 <- c(1.70, 0.85, 0.30, 4.12, 0.73, 1.98, 0.63)
gmar12 <- GSMAR(data=simudata, p=1, M=2, params=params12, model="GMAR")
pred12 <- predict(gmar12, n_ahead=10, nsimu=1000, pi=c(0.95, 0.9, 0.8),
                  pred_type="median", pi_type="two-sided")
pred12
plot(pred12)

# One-step prediction based on the exact conditional mean:
predict(gmar12, n_ahead=1, pred_type="cond_mean", plot_res=FALSE)
}
}
\references{
\itemize{
   \item Galbraith, R., Galbraith, J. 1974. On the inverses of some patterned matrices arising
           in the theory of stationary time series. \emph{Journal of Applied Probability} \strong{11}, 63-71.
   \item Kalliovirta L. (2012) Misspecification tests based on quantile residuals.
           \emph{The Econometrics Journal}, \strong{15}, 358-393.
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Meitz M., Preve D., Saikkonen P. forthcoming. A mixture autoregressive model based on Student's t-distribution.
           \emph{Communications in Statistics - Theory and Methods}, doi: 10.1080/03610926.2021.1916531
   \item Virolainen S. 2020. A mixture autoregressive model based on Gaussian and Student's t-distributions. arXiv:2003.05221 [econ.EM].
 }
}
\seealso{
\code{\link{simulateGSMAR}}, \code{\link{cond_moments}}, \code{\link{fitGSMAR}}, \code{\link{GSMAR}},
 \code{\link{quantile_residual_tests}}, \code{\link{diagnostic_plot}}
}
