% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argumentChecks.R
\name{check_pM}
\alias{check_pM}
\title{Check that p and M are correctly set}
\usage{
check_pM(p, M, model = c("GMAR", "StMAR", "G-StMAR"))
}
\arguments{
\item{p}{a positive integer specifying the autoregressive order of the model.}

\item{M}{\describe{
  \item{For \strong{GMAR} and \strong{StMAR} models:}{a positive integer specifying the number of mixture components.}
  \item{For \strong{G-StMAR} models:}{a size (2x1) integer vector specifying the number of \emph{GMAR type} components \code{M1} in the
   first element and \emph{StMAR type} components \code{M2} in the second element. The total number of mixture components is \code{M=M1+M2}.}
}}

\item{model}{is "GMAR", "StMAR", or "G-StMAR" model considered? In the G-StMAR model, the first \code{M1} components
are \emph{GMAR type} and the rest \code{M2} components are \emph{StMAR type}.}
}
\value{
Doesn't return anything but throws an informative error if something is wrong.
}
\description{
\code{check_pM} checks that the arguments p and M are correctly set.
}
