% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morePlots.R
\name{cond_moment_plot}
\alias{cond_moment_plot}
\title{Conditional mean or variance plot for GMAR, StMAR, and G-StMAR models}
\usage{
cond_moment_plot(gsmar, which_moment = c("mean", "variance"))
}
\arguments{
\item{gsmar}{a class 'gsmar' object, typically generated by \code{fitGSMAR} or \code{GSMAR}.}

\item{which_moment}{should conditional means or variances be plotted?}
}
\value{
\code{cond_moment_plot} only plots to a graphical device and does not return anything. Numerical values
 of the conditional means/variances can be extracted from the model with the dollar sign.
}
\description{
\code{cond_moment_plot} plots the one-step in-sample conditional means/variances of the model along with
 the time series contained in the model (e.g. the time series the model was fitted to). Also plots
 the regimewise conditional means/variances multiplied with the mixing weights.
}
\details{
The conditional mean plot works best if the data contains positive values only.
}
\examples{
# GMAR model
params12 <- c(1.70, 0.85, 0.30, 4.12, 0.73, 1.98, 0.63)
gmar12 <- GSMAR(data=simudata, p=1, M=2, params=params12, model="GMAR")
cond_moment_plot(gmar12, which_moment="mean")
cond_moment_plot(gmar12, which_moment="variance")

# G-StMAR model
params42gs <- c(0.04, 1.34, -0.59, 0.54, -0.36, 0.01, 0.06, 1.28, -0.36,
                0.2, -0.15, 0.04, 0.19, 9.75)
gstmar42 <- GSMAR(data=M10Y1Y, p=4, M=c(1, 1), params=params42gs,
                  model="G-StMAR")
cond_moment_plot(gstmar42, which_moment="mean")
cond_moment_plot(gstmar42, which_moment="variance")
}
\references{
\itemize{
   \item Galbraith, R., Galbraith, J. 1974. On the inverses of some patterned matrices arising
           in the theory of stationary time series. \emph{Journal of Applied Probability} \strong{11}, 63-71.
   \item Kalliovirta L. (2012) Misspecification tests based on quantile residuals.
           \emph{The Econometrics Journal}, \strong{15}, 358-393.
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Meitz M., Preve D., Saikkonen P. 2021. A mixture autoregressive model based on Student's t-distribution.
           \emph{Communications in Statistics - Theory and Methods}, doi: 10.1080/03610926.2021.1916531
   \item Virolainen S. 2021. A mixture autoregressive model based on Gaussian and Student's t-distributions.
         Studies in Nonlinear Dynamics & Econometrics,doi: 10.1515/snde-2020-0060
 }
}
\seealso{
\code{\link{profile_logliks}}, \code{\link{diagnostic_plot}}, \code{\link{fitGSMAR}}, \code{\link{GSMAR}}, \code{\link{quantile_residual_tests}},
 \code{\link{quantile_residual_plot}}
}
