% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaldAndLR.R
\name{LR_test}
\alias{LR_test}
\title{Perform likelihood ratio test}
\usage{
LR_test(gsmar1, gsmar2)
}
\arguments{
\item{gsmar1}{an object of class \code{'gsmar'} generated by \code{fitGSMAR} or \code{GSMAR}, containing
the \strong{unconstrained} model.}

\item{gsmar2}{an object of class \code{'gsmar'} generated by \code{fitGSMAR} or \code{GSMAR}, containing
the \strong{constrained} model.}
}
\value{
A list with class "htest" containing the following components:
  \item{statistic}{the value of the likelihood ratio statistics.}
  \item{parameter}{the degrees of freedom of the likelihood ratio statistic.}
  \item{p.value}{the p-value of the test.}
  \item{alternative}{a character string describing the alternative hypothesis.}
  \item{method}{a character string indicating the type of the test (likelihood ratio test).}
  \item{data.name}{a character string giving the names of the supplied models, gsmar1 and gsmar2.}
  \item{gsmar1}{the supplied argument gsmar1}
  \item{gsmar2}{the supplied argument gsmar2}
}
\description{
\code{LR_test} performs a likelihood ratio test for a GMAR, StMAR, or G-StMAR model.
}
\details{
Performs a likelihood ratio test, testing the null hypothesis that the true parameter value lies
  in the constrained parameter space specified by constraints imposed to the model \code{gsmar2}.
  Under the null, the test statistic is asymptotically \eqn{\chi^2}-distributed with \eqn{k} degrees of freedom,
  \eqn{k} being the difference in the dimensions of the unconstrained and constrained parameter spaces.

  Note that this function does \strong{not} verify that the two models are actually nested. Notably, GSMAR models
  with different autoregressive orders are not nested, whereas testing models with different numbers of regimes
  induce an identification problem and thereby unreliable test results (see the discussion related to Theorem 2
  in Virolainen, 2021).
}
\examples{
\donttest{
# GMAR p=1, M=2 model:
fit12 <- fitGSMAR(simudata, p=1, M=2, model="GMAR", ncalls=1, seeds=1)

# GMAR p=1, M=2 model with AR parameters restricted to be the same in both
# regimes:
fit12r <- fitGSMAR(simudata, p=1, M=2, model="GMAR", restricted=TRUE,
                   ncalls=1, seeds=1)

# Test with likelihood ratio test whether the AR parameters are the same in
# both regimes:
LR_test(fit12, fit12r)
}
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}(2), 247-266.
   \item Meitz M., Preve D., Saikkonen P. 2023. A mixture autoregressive model based on Student's t-distribution.
         \emph{Communications in Statistics - Theory and Methods}, \strong{52}(2), 499-515.
   \item Virolainen S. 2022. A mixture autoregressive model based on Gaussian and Student's t-distributions.
         Studies in Nonlinear Dynamics & Econometrics, \strong{26}(4) 559-580.
 }
}
\seealso{
\code{\link{Wald_test}}, \code{\link{fitGSMAR}}, \code{\link{GSMAR}}, \code{\link{diagnostic_plot}},
 \code{\link{profile_logliks}}, \code{\link{quantile_residual_tests}}, \code{\link{cond_moment_plot}}
}
