% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAINest.R
\name{get_minval}
\alias{get_minval}
\title{Returns the default smallest allowed log-likelihood for given data.}
\usage{
get_minval(data)
}
\arguments{
\item{data}{a numeric vector or class \code{'ts'} object containing the data. \code{NA} values are not supported.}
}
\value{
Returns \code{-(10^(ceiling(log10(length(data))) + 1) - 1)}
}
\description{
\code{get_minval} returns the default smallest allowed log-likelihood for given data.
}
\details{
This function exists simply to avoid duplication inside the package.
}
\seealso{
\code{\link{fitGSMAR}}, \code{\link{GAfit}}
}
\keyword{internal}
