% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_new}
\alias{system_new}
\title{Create New \code{system.txt} File}
\usage{
system_new(
  file_name = "system.txt",
  system_file = "template",
  overwrite = FALSE,
  output_directory = getwd()
)
}
\arguments{
\item{file_name}{name of the new file to create}

\item{system_file}{name of the system file to copy}

\item{overwrite}{if \code{TRUE} the new system file will overwrite any existing files present}

\item{output_directory}{\code{getwd()} directory where system file will be placed}
}
\value{
\code{TRUE} if the new file was created and \code{FALSE} otherwise
}
\description{
Copy a blank template (\code{system_file="template"}) file to the working directory or an example by specifying the following:

\itemize{
  \item \code{"template"} - Empty system file template
  \item \code{"adapt"} - Parent/metabolite model taken from the adapt manual used in estimation examples [ADAPT]
  \item \code{"two_cmt_macro"} - Two compartment model parameterized in terms of clearances (macro constants)
  \item \code{"one_cmt_macro"} - One compartment model parameterized in terms of clearances (macro constants)
  \item \code{"two_cmt_micro"} - Two compartment model parameterized in terms of rates (micro constants)
  \item \code{"one_cmt_micro"} - One compartment model parameterized in terms of rates (micro constants)
  \item \code{"mab_pk"} - General compartmental model of mAb PK from Davda 2014 [DG]
  \item \code{"pbpk"} - PBPK model of mAb disposition in mice from Shah 2012 [SB]
  \item \code{"pbpk_template"} - System parameters from Shah 2012 [SB] have been defined for all species along with the set notation to be used as a template for developing models with physiological parameters
  \item \code{"pwc"} - Example showing how to make if/then or piece-wise continuous variables  
  \item \code{"tmdd"} - Model of antibody with target-mediated drug disposition
  \item \code{"tumor"} - Transit tumor growth model taken from Lobo 2002 [LB] 
}
}
\details{
References

\itemize{
\item{[ADAPT]} Adapt 5 Users Guide \url{https://bmsr.usc.edu/files/2013/02/ADAPT5-User-Guide.pdf}
\item{[DG]} Davda et. al. mAbs (2014) 6(4):1094-1102  \url{http://doi.org/10.4161/mabs.29095}
\item{[LB]} Lobo, E.D. & Balthasar, J.P. AAPS J (2002) 4, 212-222  \url{https://doi.org/10.1208/ps040442}
\item{[SB]} Shah, D.K. & Betts, A.M. JPKPD (2012) 39 (1), 67-86 \url{https://doi.org/10.1007/s10928-011-9232-2}
}
}
\examples{
\donttest{
# To create an example system file named example_system.txt:
system_new(system_file      = "mab_pk", 
           file_name        = "system_example.txt", 
           overwrite        = TRUE,  
           output_directory = tempdir())
}
}
