% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_nm_check_ds}
\alias{system_nm_check_ds}
\title{Check NONMEM Dataset for Automatic Definitions}
\usage{
system_nm_check_ds(
  cfg,
  DS = "DSNAME",
  col_ID = "ID",
  col_CMT = "CMT",
  col_DV = "DV",
  col_TIME = "TIME",
  col_AMT = "AMT",
  col_RATE = "RATE",
  col_EVID = "EVID",
  col_GROUP = NULL,
  filter = NULL,
  INPUTS = NULL,
  OBS = NULL
)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{DS}{Name of the dataset loaded using \code{system_load_data}}

\item{col_ID}{Column of unique subject identifier}

\item{col_CMT}{Compartment column}

\item{col_DV}{Column with observations or \code{’.’} for input}

\item{col_TIME}{Column with system time of each record}

\item{col_AMT}{Infusion/dose amounts (these need to be in the same units specified in the system.txt file)}

\item{col_RATE}{Rate of infusion or \code{’.’} for bolus}

\item{col_EVID}{EVID (0 - observation, 1 dose)}

\item{col_GROUP}{Column name to use for defining similar cohorts when generating figures.}

\item{filter}{List used to filter the dataset or \code{NULL} if the whole dataset is to be used (see filter rules or  \code{\link{nm_select_records}} or a description of how to use this option)}

\item{INPUTS}{List mapping input information in the dataset to names used in the system.txt file}

\item{OBS}{List mapping obseravation information in the dataset to names used in the system.txt file}
}
\value{
list with the following elements 
\itemize{
\item{"isgood"} Boolean variable indicating success (\code{TRUE}) or failure (\code{FALSE})
\item{"mywarning"} Boolean variable indicating warnings (\code{TRUE}) or no warnings (\code{FALSE})
\item{"dsraw"} Dataframe with the filtered raw data that was used
\item{"input_records"} Rows from \code{dsraw} containing the input information
\item{"obs_records"} Rows from \code{dsraw} containing the observation information
\item{"sids"} Subject ids found in \code{dsraw}
\item{"TSsys"} system time scale used in the dataset
}
}
\description{
Checks the dataset against the information specified by \code{\link{system_define_cohorts_nm}} for validity
}
\keyword{internal}
