% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occuRN.R
\name{stan_occuRN}
\alias{stan_occuRN}
\title{Fit the Occupancy Model of Royle and Nichols (2003)}
\usage{
stan_occuRN(formula, data, K = 20, ...)
}
\arguments{
\item{formula}{Double right-hand side formula describing covariates of
detection and abundance in that order}

\item{data}{A \code{\link{unmarkedFrameOccu}} object}

\item{K}{Integer upper index of integration for N-mixture. This should be
set high enough so that it does not affect the parameter estimates.
Note that computation time will increase with K.}

\item{...}{Arguments passed to the \code{\link{stan}} call, such as
number of chains \code{chains} or iterations \code{iter}}
}
\value{
\code{ubmsFitOccuRN} object describing the model fit.
}
\description{
Fit the occupancy model of Royle and Nichols (2003), which relates
probability of detection of the species to the number of individuals
available for detection at each site.
}
\examples{
\donttest{
data(birds)
woodthrushUMF <- unmarkedFrameOccu(woodthrush.bin)
#Add a site covariate
siteCovs(woodthrushUMF) <- data.frame(cov1=rnorm(numSites(woodthrushUMF)))

(fm_wood <- stan_occuRN(~1~cov1, woodthrushUMF, chains=3, iter=300))
}

}
\references{
Royle JA, Nichols JD. 2003. Estimating abundance from
 repeated presence-absence data or point counts. Ecology 84: 777-790.
}
\seealso{
\code{\link{occuRN}}, \code{\link{unmarkedFrameOccu}}
}
