% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-available-datasets.R
\name{list_available_datasets}
\alias{list_available_datasets}
\title{List Available Datasets from UCI ML Repository}
\usage{
list_available_datasets(filter, search, area)
}
\arguments{
\item{filter}{Character. Optional query to filter available datasets based on a label.}

\item{search}{Character. Optional query to search for available datasets by name.}

\item{area}{Character. Optional query to filter available datasets based on subject area.}
}
\value{
Prints the list of available datasets.

Invisibly returns a data frame containing the list of available datasets
with columns of:
\itemize{
\item \strong{id}: Integer ID for the data set.
\item \strong{name}: Name of Dataset
\item \strong{url}: Download location of the data set
}
}
\description{
Prints a list of datasets that can be imported via the \code{fetch_ucirepo} function.
}
\examples{
list_available_datasets(search = "iris")
list_available_datasets(area = "social science")
list_available_datasets(filter = "python") # Required for now...
}
