% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlp_flow.R
\name{dtm_remove_tfidf}
\alias{dtm_remove_tfidf}
\title{Remove terms from a Document-Term-Matrix and documents with no terms based on the term frequency inverse document frequency}
\usage{
dtm_remove_tfidf(dtm, top, cutoff, prob)
}
\arguments{
\item{dtm}{an object returned by \code{\link{document_term_matrix}} or an object of class DocumentTermMatrix}

\item{top}{integer with the number of terms which should be kept as defined by the highest mean tfidf}

\item{cutoff}{numeric cutoff value to keep only terms in \code{dtm} where the tfidf obtained by \code{dtm_tfidf} is higher than this value}

\item{prob}{numeric quantile indicating to keep only terms in \code{dtm} where the tfidf obtained by \code{dtm_tfidf} is higher than 
the \code{prob} percent quantile}
}
\value{
a sparse Matrix as returned by \code{sparseMatrix} or an object of class \code{DocumentTermMatrix} 
where terms with high tfidf are kept and documents without any remaining terms are removed
}
\description{
Remove terms from a Document-Term-Matrix and documents with no terms based on the term frequency inverse document frequency.
Either giving in the maximum number of terms (argument \code{top}), the tfidf cutoff (argument \code{cutoff})
or a quantile (argument \code{prob})
}
\examples{
data(brussels_reviews_anno)
x <- subset(brussels_reviews_anno, xpos == "NN")
x <- x[, c("doc_id", "lemma")]
x <- document_term_frequencies(x)
dtm <- document_term_matrix(x)
dtm <- dtm_remove_lowfreq(dtm, minfreq = 10)
dim(dtm)

## Keep only terms with high tfidf
x <- dtm_remove_tfidf(dtm, top=50)
dim(x)

## Keep only terms with tfidf above 1.1
x <- dtm_remove_tfidf(dtm, cutoff=1.1)
dim(x)

## Keep only terms with tfidf above the 60 percent quantile
x <- dtm_remove_tfidf(dtm, prob=0.6)
dim(x)
}
