% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlp_morphological.R
\name{cbind_morphological}
\alias{cbind_morphological}
\title{Add morphological features to an annotated dataset}
\usage{
cbind_morphological(x, term = "feats")
}
\arguments{
\item{x}{a data.frame or data.table as returned by \code{as.data.frame(udpipe_annotate(...))}}

\item{term}{the name of the field in \code{x} which contains the morphological features. Defaults to 'feats'.}
}
\value{
\code{x} in the same order with extra columns added (at least the column has_morph is added indicating
if any morphological features are present and as well extra columns for each possible morphological feature in the data)
}
\description{
The result of \code{\link{udpipe_annotate}} which is put into a data.frame 
returns a field called \code{feats} containing morphological features as defined at 
\url{http://universaldependencies.org/u/feat/index.html}. If there are several of these features,
these are concatenated with the \code{|} symbol. This function extracts each of these morphological 
features separately and adds these as extra columns to the data.frame
}
\examples{
\dontrun{
udmodel <- udpipe_download_model(language = "english-ewt")
udmodel <- udpipe_load_model(file = udmodel$file_model)
x <- udpipe_annotate(udmodel, 
                     x = "The economy is weak but the outlook is bright")
x <- as.data.frame(x)
x <- cbind_morphological(x, term = "feats")
}

f <- system.file(package = "udpipe", "dummydata", "traindata.conllu")
x <- udpipe_read_conllu(f)
x <- cbind_morphological(x, term = "feats")
}
