% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterMatrix.R
\name{scatterMatrix}
\alias{scatterMatrix}
\alias{print.scatterMatrix}
\title{scatterMatrix}
\usage{
scatterMatrix(
  dat,
  items = NULL,
  plotSize = 180,
  sizeMultiplier = 1,
  axisLabels = "none",
  normalHist = TRUE,
  progress = NULL,
  theme = ggplot2::theme_minimal(),
  hideGrid = TRUE,
  ...
)

\method{print}{scatterMatrix}(x, ...)
}
\arguments{
\item{dat}{A dataframe containing the items in the scale. All variables in
this dataframe will be used if items is NULL.}

\item{items}{If not NULL, this should be a character vector with the names
of the variables in the dataframe that represent items in the scale.}

\item{plotSize}{Size of the final plot in millimeters.}

\item{sizeMultiplier}{Allows more flexible control over the size of the plot
elements}

\item{axisLabels}{Passed to ggpairs function to set axisLabels.}

\item{normalHist}{Whether to use the default ggpairs histogram on the
diagonal of the scattermatrix, or whether to use the \code{\link[=normalHist]{normalHist()}} version.}

\item{progress}{Whether to show a progress bar; set to \code{FALSE} to disable. See
\code{\link[GGally:ggpairs]{GGally::ggpairs()}} help for more information.}

\item{theme}{The ggplot2 theme to use.}

\item{hideGrid}{Whether to hide the gridlines in the plot.}

\item{...}{Additional arguments for \code{scatterMatrix()} are passed on to
\code{\link[=normalHist]{normalHist()}}, and additional arguments for the \code{print} method are passed
on to the default \code{print} method.}

\item{x}{The object to print.}
}
\value{
An object with the input and several output variables. Most notably:
\item{output$scatterMatrix}{A scattermatrix with histograms on the diagonal
and correlation coefficients in the upper right half.}
}
\description{
scatterMatrix produced a matrix with jittered scatterplots, histograms, and
correlation coefficients.
}
\examples{

### Note: the 'not run' is simply because running takes a lot of time,
###       but these examples are all safe to run!
\dontrun{

### Generate a datafile to use
exampleData <- data.frame(item1=rnorm(100));
exampleData$item2 <- exampleData$item1+rnorm(100);
exampleData$item3 <- exampleData$item1+rnorm(100);
exampleData$item4 <- exampleData$item2+rnorm(100);
exampleData$item5 <- exampleData$item2+rnorm(100);

### Use all items
scatterMatrix(dat=exampleData);
}

}
\author{
Gjalt-Jorn Peters

Maintainer: Gjalt-Jorn Peters \href{mailto:gjalt-jorn@userfriendlyscience.com}{gjalt-jorn@userfriendlyscience.com}
}
\keyword{univar}
\keyword{utilities}
