% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{ukb_gen_het}
\alias{ukb_gen_het}
\title{Heterozygosity outliers}
\usage{
ukb_gen_het(data, all.het = FALSE)
}
\arguments{
\item{data}{A UKB dataset created with \code{\link{ukb_df}}.}

\item{all.het}{Set \code{all.het = TRUE} for heterozygosity scores for all samples. By default \code{all.het = FALSE} returns a vector of sample IDs for individuals +/-3SD from the mean heterozygosity.}
}
\value{
A vector of IDs if \code{all.het = FALSE} (default), or a dataframe with ID, heterozygosity and PCA-corrected heterozygosity if \code{all.het = TRUE}.
}
\description{
\strong{Defunct. See help("ukb_defunct")}.

Heterozygosity outliers are typically removed from genetic association analyses. This function returns either a vector of heterozygosity outliers to remove (+/- 3sd from mean heterozygosity), or a data frame with heterozygosity scores for all samples.
}
\details{
UKB have published \href{http://www.ukbiobank.ac.uk/wp-content/uploads/2014/04/UKBiobank_genotyping_QC_documentation-web.pdf}{full details of genotyping and quality control} for the interim genotype data.
}
\examples{
\dontrun{
#' # Heterozygosity outliers (+/-3SD)
outlier_het_ids <- ukb_gen_het(my_ukb_data)

# Retrieve all raw and pca-corrected heterozygosity scores
ukb_het <- ukb_gen_het(my_ukb_data, all.het = TRUE)
}
}
