% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_wide2long}
\alias{umx_wide2long}
\title{Change data 2-twin family data from wide to long format.}
\usage{
umx_wide2long(data, sep = "_T", verbose = FALSE)
}
\arguments{
\item{data}{a dataframe containing twin data.}

\item{sep}{the string between the var name and twin suffix, i.e., var_T1 = _T}

\item{verbose}{Report the non-twin and twin columns (default = FALSE).}
}
\value{
- long-format dataframe
}
\description{
Just detects the data columns for twin 1, and twin 2, then returns them stacked
on top of each other (rbind) with the non-twin specific columns copied for each as well.
}
\examples{
long = umx_wide2long(data = twinData, sep = "")
long = umx_wide2long(data = twinData, sep = "", verbose = TRUE)
str(long)
str(twinData)
}
\seealso{
Other Twin Data functions: \code{\link{umx_long2wide}},
  \code{\link{umx_make_TwinData}},
  \code{\link{umx_residualize}},
  \code{\link{umx_scale_wide_twin_data}}, \code{\link{umx}}
}
