% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.r
\name{umxSuperModel}
\alias{umxSuperModel}
\title{Make a multi-group model}
\usage{
umxSuperModel(name = "top", ..., autoRun = TRUE)
}
\arguments{
\item{name}{The name for the container model (default = 'top')}

\item{...}{Models forming the multiple groups contained in the supermodel.}

\item{autoRun}{Whether to run the supermodel before returning it (default = TRUE)}
}
\value{
- \code{\link{mxModel}}
}
\description{
umxSuperModel takes 1 or more models and wraps them in a supermodel with a
\code{\link{mxFitFunctionMultigroup}} fit function that minimises the sum of the
fits of the sub-models.
}
\examples{
library(umx)
# Simulate two sets of data in which X and Y correlate ~ .4
tmp = umx_make_TwinData(nMZpairs = 100, nDZpairs = 150, 
		AA = 0, CC = .4, EE = .6, varNames = c("x", "y"))
# Group 1
ds1 = tmp[[1]];
m1Data = mxData(cov(ds1), type = "cov", numObs = nrow(ds1), means=umx_means(ds1))
# Group 2
ds2 = tmp[[2]];
m2Data = mxData(cov(ds2), type = "cov", numObs = nrow(ds2), means=umx_means(ds2))
cor(ds1); cor(ds2)

manifests = names(ds1)
# Model 1
m1 <- umxRAM("m1", data = m1Data,
	umxPath("x", to = "y", labels = "beta"),
	umxPath(var = manifests, labels = c("Var_x", "Resid_y_grp1")),
	umxPath(means = manifests, labels = c("Mean_x", "Mean_y"))
)
# Model 2
m2 <- umxRAM("m2", data = m2Data,
	umxPath("x", to = "y", labels = "beta"),
	umxPath(var = manifests, labels=c("Var_x", "Resid_y_grp2")),
	umxPath(means = manifests, labels=c("Mean_x", "Mean_y"))
)
# Place m1 and m2 into a supermodel, and autoRun it
# NOTE: umxSummary is not yet smart/certain enough to compute saturated models etc
# and report multiple groups correctly.
m3 = umxSuperModel('top', m1, m2)
summary(m3)
}
\references{
- \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
\seealso{
- \code{\link{mxFitFunctionMultigroup}}, \code{\link{umxRAM}}

Other Core Modelling Functions: \code{\link{plot.MxModel}},
  \code{\link{umxAlgebra}}, \code{\link{umxMatrix}},
  \code{\link{umxPath}}, \code{\link{umxRAM}},
  \code{\link{umxRun}}, \code{\link{umx}}
}
