% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_as_numeric}
\alias{umx_as_numeric}
\title{umx_as_numeric}
\usage{
umx_as_numeric(df, force = FALSE)
}
\arguments{
\item{df}{A \code{\link{data.frame}} to convert}

\item{force}{Whether to force conversion to numeric for non-numeric columns (defaults to FALSE)}
}
\value{
- data.frame
}
\description{
Convert each column of a dataframe to numeric
}
\examples{
df = mtcars
# make mpg into string
df$mpg = as.character(df$mpg)
df$cyl = factor(df$cyl)
df = umx_as_numeric(df); str(df)
df = umx_as_numeric(df, force=TRUE); str(df)
# Make one variable alpha
df$mpg = c(letters,letters[1:6]); str(df)
df = umx_as_numeric(df, force=TRUE); str(df)
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
Other Data Functions: \code{\link{umxCovData}},
  \code{\link{umxHetCor}},
  \code{\link{umxPadAndPruneForDefVars}},
  \code{\link{umx_cov2raw}}, \code{\link{umx_lower2full}},
  \code{\link{umx_make_MR_data}},
  \code{\link{umx_make_bin_cont_pair_data}},
  \code{\link{umx_make_fake_data}},
  \code{\link{umx_polychoric}},
  \code{\link{umx_polypairwise}},
  \code{\link{umx_polytriowise}},
  \code{\link{umx_read_lower}}, \code{\link{umx_rename}},
  \code{\link{umx_reorder}}, \code{\link{umx_stack}},
  \code{\link{umx_swap_a_block}}, \code{\link{umx}}
}
