% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxSummaryACE}
\alias{umxSummaryACE}
\alias{umxSummary.MxModelACE}
\title{Shows a compact, publication-style, summary of a umx Cholesky ACE model}
\usage{
umxSummaryACE(
  model,
  digits = 2,
  file = getOption("umx_auto_plot"),
  comparison = NULL,
  std = TRUE,
  showRg = FALSE,
  CIs = TRUE,
  report = c("markdown", "html"),
  returnStd = FALSE,
  extended = FALSE,
  zero.print = ".",
  show,
  ...
)
}
\arguments{
\item{model}{an \code{\link[=mxModel]{mxModel()}} to summarize.}

\item{digits}{round to how many digits (default = 2).}

\item{file}{The name of the dot file to write: "name" = use the name of the model.
Defaults to NA = do not create plot output.}

\item{comparison}{you can run mxCompare on a comparison model (NULL).}

\item{std}{Whether to standardize the output (default = TRUE).}

\item{showRg}{= whether to show the genetic correlations (FALSE).}

\item{CIs}{Whether to show Confidence intervals if they exist (TRUE).}

\item{report}{If "html", then open an html table of the results.}

\item{returnStd}{Whether to return the standardized form of the model (default = FALSE).}

\item{extended}{how much to report (FALSE).}

\item{zero.print}{How to show zeros (".")}

\item{show}{std, raw etc. Not implemented for umxACE yet.}

\item{...}{Other parameters to control model summary.}
}
\value{
\itemize{
\item optional \code{\link[=mxModel]{mxModel()}}
}
}
\description{
Summarize a fitted Cholesky model returned by \code{\link[=umxACE]{umxACE()}}. Can control digits, report comparison model fits,
optionally show the Rg (genetic and environmental correlations), and show confidence intervals. the report parameter allows
drawing the tables to a web browser where they may readily be copied into non-markdown programs like Word.
}
\details{
See documentation for other umx models here: \code{\link[=umxSummary]{umxSummary()}}.
}
\examples{
require(umx)
data(twinData)
selDVs = c("bmi1", "bmi2")
mzData <- subset(twinData, zygosity == "MZFF")
dzData <- subset(twinData, zygosity == "DZFF")
m1 = umxACE(selDVs = selDVs, dzData = dzData, mzData = mzData)
umxSummary(m1)
\dontrun{
umxSummaryACE(m1, file = NA);
umxSummaryACE(m1, file = "name", std = TRUE)
stdFit = umxSummaryACE(m1, returnStd = TRUE);
}
}
\references{
\itemize{
\item \url{https://tbates.github.io},  \url{https://github.com/tbates/umx}
}
}
\seealso{
\itemize{
\item \code{\link[=umxACE]{umxACE()}}, \code{\link[=plot.MxModelACE]{plot.MxModelACE()}}, \code{\link[=umxModify]{umxModify()}}
}

Other Twin Reporting Functions: \code{\link{umxPlotCP}()},
  \code{\link{umxReduceACE}()},
  \code{\link{umxReduceGxE}()}, \code{\link{umxReduce}()},
  \code{\link{umxSummarizeTwinData}()},
  \code{\link{umxSummaryACEcov}()},
  \code{\link{umxSummaryACEv}()},
  \code{\link{umxSummaryCP}()},
  \code{\link{umxSummaryGxEbiv}()},
  \code{\link{umxSummaryGxE}()},
  \code{\link{umxSummaryIP}()},
  \code{\link{umxSummarySexLim}()},
  \code{\link{umxSummarySimplex}()}, \code{\link{umx}}
}
\concept{Twin Reporting Functions}
